/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.text.rules;

import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.js.text.rules.JSNumberDetector;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;

public class JSNumberRule
extends ExtendedWordRule {
    private static Pattern NUMBER_PATTERN = Pattern.compile("(?:(?:0[xX][0-9a-fA-F]+)|(?:(?:[0-9]+(?:\\.[0-9]*)?|\\.[0-9]+)(?:[eE][-+]?\\d+)?))");

    public JSNumberRule(IToken token) {
        super((IWordDetector)new JSNumberDetector(), token, false);
    }

    protected boolean wordOK(String word, ICharacterScanner scanner) {
        return NUMBER_PATTERN.matcher(word).matches();
    }
}

